﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Password_Validation
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda NumberUpperCase() akceptuje argument w postaci ciągu
        // tekstowego i zwraca liczbę znajdujących się w nim dużych liter.
        private int NumberUpperCase(string str)
        {
            int upperCase = 0;  // Liczba dużych liter.

            // Oblicznie wystąpień dużych liter w ciągu tekstowym.
            foreach (char ch in str)
            {
                if (char.IsUpper(ch))
                {
                    upperCase++;
                }
            }

            // Zwrot liczby wystąpień dużych liter w ciągu tekstowym.
            return upperCase;
        }

        // Metoda NumberLowerCase() akceptuje argument w postaci ciągu
        // tekstowego i zwraca liczbę znajdujących się w nim małych liter.
        private int NumberLowerCase(string str)
        {
            int lowerCase = 0;  // Liczba małych liter.

            // Oblicznie wystąpień małych liter w ciągu tekstowym.
            foreach (char ch in str)
            {
                if (char.IsLower(ch))
                {
                    lowerCase++;
                }
            }

            // Zwrot liczby wystąpień małych liter w ciągu tekstowym.
            return lowerCase;
        }

        // Metoda NumberDigits() akceptuje argument w postaci ciągu
        // tekstowego i zwraca liczbę znajdujących się w nim cyfr.
        private int NumberDigits(string str)
        {
            int digits = 0;  // Liczba cyfr.

            // Oblicznie wystąpień cyfr w ciągu tekstowym.
            foreach (char ch in str)
            {
                if (char.IsDigit(ch))
                {
                    digits++;
                }
            }

            // Zwrot liczby wystąpień cyfr w ciągu tekstowym.
            return digits;
        }

        private void checkPasswordButton_Click(object sender, EventArgs e)
        {
            const int MIN_LENGTH = 8;  // Minimalna długość hasła.

            // Pobranie hasła z kontrolki TextBox.
            string password = passwordTextBox.Text;

            // Weryfikacja hasła.
            if (password.Length >= MIN_LENGTH &&
                NumberUpperCase(password) >= 1 &&
                NumberLowerCase(password) >= 1 &&
                NumberDigits(password) >= 1)
            {
                MessageBox.Show("Hasło jest poprawne.");
            }
            else
            {
                MessageBox.Show("Hasło nie spełniło " +
                    "minimalnych wymagań.");
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
